"use client";
import Image from "next/image";
import { useTranslations } from "next-intl";
import { motion, Variants } from "framer-motion";

export default function HeroSection() {
  const t = useTranslations("Hero");

  const fadeUp = (delay: number): Variants => ({
    hidden: { opacity: 0, y: 30 },
    visible: {
      opacity: 1,
      y: 0,
      transition: { duration: 0.8, ease: [0.25, 0.1, 0.25, 1], delay },
    },
  });

  return (
    <section
      className="relative flex flex-col items-center justify-center text-center h-[70vh] md:h-[740px] bg-cover bg-center bg-no-repeat 
             before:absolute before:inset-0 before:bg-blue-900/30 before:z-0"
      style={{ backgroundImage: "url('/images/hero.jpg')" }}
    >
      <div className="relative z-10 w-[80%]  px-4 h-[50%] bg-black/30 rounded-2xl p-6 backdrop-blur-[5px] flex flex-col justify-center items-center text-center">
        <motion.div
          initial={{ opacity: 0, scale: 0.9 }}
          animate={{ opacity: 1, scale: 1 }}
          transition={{ duration: 0.8, ease: [0.25, 0.1, 0.25, 1] }}
        >
          <Image
            src="/images/white_logo.png"
            alt="Logo"
            width={120}
            height={60}
            className="mx-auto mb-4"
          />
        </motion.div>

        <motion.p
          className="text-white uppercase text-md"
          variants={fadeUp(0.2)}
          initial="hidden"
          animate="visible"
        >
          {t("tagline")}
        </motion.p>

        <motion.h1
          className="h1Text text-white mt-2"
          variants={fadeUp(0.4)}
          initial="hidden"
          animate="visible"
        >
          {t("title")}
        </motion.h1>

        <motion.p
          className="text-white text-lg md:text-4xl mt-4"
          variants={fadeUp(0.6)}
          initial="hidden"
          animate="visible"
        >
          {t("subtitle")}
        </motion.p>
      </div>
    </section>
  );
}
