"use client";

import CustomSection from "@/componnets/custom-ship";
import IraqSection from "@/componnets/IraqShippingSection";
import IraqShippingSection from "@/componnets/IraqShippingSection";
import ShippingSection from "@/componnets/shipping-card";
import { useTranslations } from "next-intl";

const Shipping = () => {
  const t = useTranslations("ShippingSaudi");

  return (
    <section className="custom-container my-[5rem]" id="services">
      <ShippingSection
        imageLeft={true}
        title={t("title")}
        image={{ src: "/images/container_saudi.jpg", alt: "Container hoist" }}
        badgeImage={{ src: "/images/saudi.png", alt: "KSA Flag" }}
        items={[
          {
            title: t("courier_title"),
            description: t("courier_desc"),
          },
          {
            title: t("cargo_title"),
            description: t("cargo_desc"),
          },
        ]}
      />
      <IraqSection
        title={t("ShippingIraq.title")}
        image={{ src: "/images/iraq.jpg", alt: "Iraq shipping" }}
        flag={{ src: "/images/iraq_flag.png", alt: "Iraq Flag" }}
        items={[
          {
            title: t("ShippingIraq.sea_title"),
            description: t("ShippingIraq.sea_desc"),
          },
          {
            title: t("ShippingIraq.land_title"),
            description: t("ShippingIraq.land_desc"),
          },
          {
            title: t("ShippingIraq.air_title"),
            description: t("ShippingIraq.air_desc"),
          },
        ]}
      />
      <ShippingSection
        imageLeft={true}
        title={t("ShippingSyria.title")}
        image={{ src: "/images/port.jpg", alt: "Container hoist" }}
        badgeImage={{ src: "/images/syria.png", alt: "SYRIA Flag" }}
        items={[
          {
            title: t("ShippingSyria.sea_title"),
            description: t("ShippingSyria.sea_desc"),
          },
          {
            title: t("ShippingSyria.land_title"),
            description: t("ShippingSyria.land_desc"),
          },
          {
            title: t("ShippingSyria.land_title2"),
            description: t("ShippingSyria.land_desc2"),
          },
        ]}
      />
      <CustomSection
        image={{ src: "/images/custom.jpg", alt: "Iraq shipping" }}
        items={[
          {
            title: t("Land.car_title"),
            description: t("Land.car_desc"),
          },
          {
            title: t("Land.customs_title"),
            description: t("Land.customs_desc"),
          },
        ]}
      />
    </section>
  );
};

export default Shipping;
