import { NextRequest, NextResponse } from "next/server";
import createMiddleware from "next-intl/middleware";
import { localePrefix } from "@/config/locales";
import locales from "@/config/locales";
/* import { StaticKey } from "./types";
 */
const userOnlyRoutes = ["/cart", "/profile"];

export default function middleware(request: NextRequest) {
  const hasLangCookie = request.cookies.get("NEXT_LOCALE")?.value;

  if (!hasLangCookie) {
    const response = NextResponse.redirect(request.nextUrl);
    response.cookies.set("NEXT_LOCALE", "ar", { path: "/" });
    return response;
  }

  const intlMiddleware = createMiddleware({
    locales,
    defaultLocale: "ar",
    localePrefix,
  });

  const response = intlMiddleware(request);

  const { pathname } = request.nextUrl;
  const isUserRoute = userOnlyRoutes.some((route) => pathname.includes(route));

  /*   if (isUserRoute) {
    const userCookie = request.cookies.get(StaticKey.CURRENT_USER)?.value;
    if (!userCookie) {
      return NextResponse.redirect(new URL("/", request.url));
    }
  }
 */
  return response;
}

export const config = {
  matcher: ["/((?!_next|_vercel|.*\\..*).*)"],
};
