"use client";

import Link from "next/link";
import { usePathname } from "next/navigation";
import { useTranslations } from "next-intl";
import { CustomDropdownMenu } from "@/componnets/dropdown-menu";
import { Languages } from "lucide-react";

const Navbar = () => {
  const pathname = usePathname();
  const t = useTranslations("Navbar");

  const navLinks = [
    { href: "/", label: t("home") },
    { scrollTo: "services", label: t("services") },
    { scrollTo: "about", label: t("about_us") },
    { scrollTo: "contact", label: t("contact_us") },
  ];

  const handleScroll = (e: React.MouseEvent, id: string) => {
    e.preventDefault();
    const el = document.getElementById(id);
    if (el) {
      const yOffset = -80;
      const y = el.getBoundingClientRect().top + window.pageYOffset + yOffset;

      window.scrollTo({ top: y, behavior: "smooth" });
    }
  };

  const languages = [
    { code: "en", label: "English" },
    { code: "ar", label: "العربية" },
  ];

  const currentLang =
    languages.find((l) => pathname.startsWith(`/${l.code}`)) || languages[0];

  return (
    <header className="z-50 bg-transparent absolute w-full">
      <div className="max-w-7xl mx-auto flex items-center justify-between px-4 py-3">
        <Link href="/" className="flex items-center">
          <img
            src="/images/logo.png"
            alt="Logo"
            className="h-10 w-auto object-contain"
          />
        </Link>

        <nav className="hidden md:flex items-center gap-8 relative">
          {navLinks.map(({ href, label, scrollTo }) => (
            <div key={label} className="relative">
              {scrollTo ? (
                <a
                  href={`#${scrollTo}`}
                  onClick={(e) => handleScroll(e, scrollTo)}
                  className={`h5Text transition-colors ${
                    pathname === "/" ||
                    pathname.startsWith("/ar") ||
                    pathname.startsWith("/en")
                      ? "text-white"
                      : "text-green-800"
                  } hover:text-secondary cursor-pointer`}
                >
                  {label}
                </a>
              ) : (
                <Link
                  href={href!}
                  className={`h5Text transition-colors ${
                    pathname === href ? "text-secondary" : "text-white"
                  } hover:text-secondary`}
                >
                  {label}
                </Link>
              )}
            </div>
          ))}
        </nav>

        <CustomDropdownMenu
          dropdownMenuTrigger={
            <span className="flex items-center gap-2 px-3 py-2 rounded-lg cursor-pointer text-white hover:text-secondary">
              <Languages size={20} />
              {currentLang.label}
            </span>
          }
          className="bg-white shadow-md rounded-lg py-2"
        >
          <div className="flex flex-col">
            {languages.map((lang) => (
              <Link
                key={lang.code}
                href={`/${lang.code}${pathname.replace(/^\/(en|ar)/, "")}`}
                className="px-4 py-2 text-gray-700 hover:bg-gray-100 cursor-pointer"
              >
                {lang.label}
              </Link>
            ))}
          </div>
        </CustomDropdownMenu>
      </div>
    </header>
  );
};

export default Navbar;
