"use client";
import Image from "next/image";
import React from "react";
import { useLocale, useTranslations } from "next-intl";
import { motion, easeOut } from "framer-motion";

const containerVariants = {
  hidden: { opacity: 0 },
  visible: {
    opacity: 1,
    transition: { staggerChildren: 0.12, delayChildren: 0.08 },
  },
};

const cardVariants = {
  hidden: { opacity: 0, y: 14 },
  visible: {
    opacity: 1,
    y: 0,
    transition: { duration: 0.35, ease: easeOut },
  },
};

const FeaturesSection = () => {
  const t = useTranslations("FeaturesSection");

  const locale = useLocale();
  const isArabic = locale === "ar";
  const features = [
    {
      title: t("strategic_title"),
      description: t("strategic_desc"),
      icon: "/images/icons/map-pin.svg",
    },
    {
      title: t("customized_title"),
      description: t("customized_desc"),
      icon: "/images/icons/interaction.svg",
    },
    {
      title: t("relationships_title"),
      description: t("relationships_desc"),
      icon: "/images/icons/discount.svg",
    },
    {
      title: t("fast_title"),
      description: t("fast_desc"),
      icon: "/images/icons/arrow.svg",
    },
    {
      title: t("prices_title"),
      description: t("prices_desc"),
      icon: "/images/icons/map-pin.svg",
    },
  ];

  return (
    <section className="custom-container my-[5rem]">
      <div>
        <div className="text-center mb-16">
          <h1 className="text-4xl md:text-5xl font-bold text-orange-500">
            {t("title")}
          </h1>
        </div>

        <div className="flex flex-col md:flex-row items-start justify-between gap-8 md:gap-16 mx-auto">
          <div className="relative hidden lg:flex justify-center items-center">
            <div className="absolute w-[380px] h-[380px] bg-[#E6F4FA] rounded-full -z-10" />
            <Image
              src={
                locale === "en" ? "/images/persone.png" : "/images/Frame 26.png"
              }
              alt="Feature Image"
              width={500}
              height={500}
              className="w-full h-[500px] object-contain relative z-10"
            />
          </div>

          <motion.div
            variants={containerVariants}
            initial="hidden"
            whileInView="visible"
            viewport={{ once: true, amount: 0.2 }}
            className="flex-1 grid grid-cols-1 md:grid-cols-2 gap-6"
          >
            {features.map((feature, idx) => (
              <motion.div
                key={idx}
                variants={cardVariants}
                className="group bg-white p-6 rounded-lg shadow-md flex items-start gap-3 min-h-[135px]
             transition-colors duration-700 delay-500 ease-out hover:bg-gray-200 hover:shadow-lg"
              >
                <div className="flex-1">
                  <h5
                    className={`text-lg md:text-[22px] leading-[120%] font-bold flex flex-row items-center gap-2 text-primary mb-2 ${
                      isArabic ? "font-[Cairo]" : "font-[Poppins]"
                    }`}
                  >
                    <Image
                      src={feature.icon}
                      alt={feature.title}
                      width={28}
                      height={28}
                      className="object-contain transition duration-700 ease-out
                   group-hover:grayscale group-hover:opacity-80 overflow-clip"
                    />
                    {feature.title}
                  </h5>
                  <p className="text-[#888888] font-poppins text-[16px] transition-colors duration-700">
                    {feature.description}
                  </p>
                </div>
              </motion.div>
            ))}
          </motion.div>
        </div>
      </div>
    </section>
  );
};

export default FeaturesSection;
