"use client";
import React from "react";
import FeatureCard from "@/componnets/feature-card";
import { useTranslations } from "next-intl";

const FeaturesSectionWithImage = () => {
  const t = useTranslations("FeaturesWithImage");

  const features = [
    {
      title: t("speed_title"),
      description: t("speed_desc"),
      image: "/images/icons/Group.svg",
      titleColor: "#0F5132",
      descriptionColor: "",
      bgColor: "bg-white/90",
      fontFamily: "poppins",
    },
    {
      title: t("secure_title"),
      description: t("secure_desc"),
      image: "/images/icons/secure 1.svg",
      titleColor: "#B45309",
      descriptionColor: "",
      bgColor: "bg-white/80",
      fontFamily: "poppins",
    },
    {
      title: t("support_title"),
      description: t("support_desc"),
      image: "/images/icons/customer-service 1.svg",
      titleColor: "#1E3A8A",
      descriptionColor: "",
      bgColor: "bg-white/95",
      fontFamily: "poppins",
    },
  ];

  return (
    <section className="w-full mt-[12rem] md:mb-[6rem]">
      <div
        className="hidden md:block w-full h-[300px]"
        style={{
          backgroundImage: "url('/images/map.png')",
          backgroundSize: "cover",
          backgroundPosition: "center",
          backgroundRepeat: "no-repeat",
        }}
      >
        <div className="relative z-10 flex flex-col md:flex-row justify-center items-center gap-4 md:gap-2 h-full px-4 md:px-8">
          {features.map((feature, index) => (
            <div
              key={index}
              className="w-full md:w-1/3 md:max-w-[400px] lg:max-w-[420px] items-center"
            >
              <FeatureCard {...feature} />
            </div>
          ))}
        </div>
      </div>

      <div className="md:hidden flex flex-col justify-center items-center gap-6 px-4">
        {features.map((feature, index) => (
          <div key={index} className="w-full max-w-[400px] items-center">
            <FeatureCard {...feature} />
          </div>
        ))}
      </div>
    </section>
  );
};

export default FeaturesSectionWithImage;
