"use client";
import React from "react";
import Image from "next/image";
import { useLocale } from "next-intl";

type FeatureCardProps = {
  title: string;
  description: string;
  image: string;
  titleColor?: string;
  descriptionColor?: string;
  bgColor?: string;
  fontFamily?: string;
};

const FeatureCard: React.FC<FeatureCardProps> = ({
  title,
  description,
  image,
  titleColor = "#1F2937",
  descriptionColor = "#4B5563",
  bgColor = "bg-white/90",
  fontFamily = "poppins",
}) => {
  const locale = useLocale();
  const appliedFont = locale === "ar" ? "Cairo" : fontFamily;

  return (
    <div
      className={`!bg-white rounded-2xl p-3 md:p-8 shadow-lg border border-white/20 
      w-full md:max-w-[370px] h-fit md:h-[300px] lg:h-[250px] 
      flex flex-col justify-start items-center text-center 
      -translate-y-[125px] ${bgColor}`}
    >
      <div className="w-14 h-14 md:w-16 md:h-16 mb-4 relative">
        <Image src={image} alt={title} fill className="object-contain" />
      </div>

      <h3
        className="text-xl md:text-2xl font-bold mb-3"
        style={{ color: titleColor, fontFamily: appliedFont }}
      >
        {title}
      </h3>

      <p
        className="text-sm md:text-base leading-relaxed px-2"
        style={{ color: descriptionColor, fontFamily: appliedFont }}
      >
        {description}
      </p>
    </div>
  );
};

export default FeatureCard;
