"use client";
import Image from "next/image";
import Link from "next/link";
import { Facebook, Instagram, Music2 } from "lucide-react";
import { useTranslations, useLocale } from "next-intl";
import { usePathname } from "next/navigation";

export default function Footer() {
  const year = new Date().getFullYear();
  const t = useTranslations("Footer");
  const locale = useLocale();
  const isArabic = locale === "ar";
  const pathname = usePathname();

  const handleScroll = (e: React.MouseEvent, id: string) => {
    e.preventDefault();
    const el = document.getElementById(id);
    if (el) {
      const yOffset = -80;
      const y = el.getBoundingClientRect().top + window.pageYOffset + yOffset;
      window.scrollTo({ top: y, behavior: "smooth" });
    }
  };

  return (
    <footer className="bg-[#2f2f2f] text-white py-10 px-4">
      <div className="flex flex-col items-center text-center max-w-7xl mx-auto">
        <Image
          src="/images/logo.png"
          alt={t("brand")}
          width={90}
          height={65}
          className="h-[60px] w-auto mb-3"
          priority
        />

        <h2 className="text-base md:text-lg font-semibold uppercase tracking-wide mb-1">
          {t("brand")}
        </h2>

        <p className="text-sm md:text-base font-semibold text-white/90 mb-2 tracking-wide">
          {t("tagline")}
        </p>
        <div className="flex items-center justify-center mb-5 md:mb-3">
          <a
            href="tel:+97142963334"
            className="text-sm md:text-base text-white/90 font-bold hover:text-white transition-colors flex items-center gap-2"
          >
            <svg
              xmlns="http://www.w3.org/2000/svg"
              viewBox="0 0 24 24"
              fill="none"
              stroke="#F97316"
              strokeWidth="2"
              strokeLinecap="round"
              strokeLinejoin="round"
              className="w-5 h-5"
            >
              <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07A19.5 19.5 0 0 1 3.07 12.81 19.79 19.79 0 0 1 0 4.18 2 2 0 0 1 2 2h3a2 2 0 0 1 2 1.72 12.11 12.11 0 0 0 .65 2.73 2 2 0 0 1-.45 2.11l-1.27 1.27a16 16 0 0 0 6.9 6.9l1.27-1.27a2 2 0 0 1 2.11-.45 12.11 12.11 0 0 0 2.73.65A2 2 0 0 1 22 16.92z" />
            </svg>
            +971&nbsp;4&nbsp;296&nbsp;3334
          </a>
        </div>

        <div
          className={`flex flex-row ${
            isArabic ? "flex-row-reverse" : ""
          } justify-between w-[100%]`}
        >
          <nav
            className={`flex flex-wrap ${
              isArabic ? "flex-row-reverse" : ""
            } justify-center gap-8 text-xs md:text-sm font-medium uppercase mb-6`}
          >
            <a
              href="#home"
              onClick={(e) => handleScroll(e, "home")}
              className="hover:text-white/90 transition-colors cursor-pointer"
            >
              {t("home")}
            </a>

            <a
              href="#about"
              onClick={(e) => handleScroll(e, "about")}
              className="hover:text-white/90 transition-colors cursor-pointer"
            >
              {t("about")}
            </a>

            <a
              href="#services"
              onClick={(e) => handleScroll(e, "services")}
              className="hover:text-white/90 transition-colors cursor-pointer"
            >
              {t("services")}
            </a>

            <a
              href="#contact"
              onClick={(e) => handleScroll(e, "contact")}
              className="hover:text-white/90 transition-colors cursor-pointer"
            >
              {t("contact")}
            </a>
          </nav>

          {/* Socials */}
          <div className="flex items-center justify-center gap-5 mb-6">
            <Link
              href="https://facebook.com"
              target="_blank"
              className="hover:text-white transition-colors"
            >
              <Facebook className="h-5 w-5" />
            </Link>
            <Link
              href="https://instagram.com"
              target="_blank"
              className="hover:text-white transition-colors"
            >
              <Instagram className="h-5 w-5" />
            </Link>
            <Link
              href="https://tiktok.com"
              target="_blank"
              className="hover:text-white transition-colors"
            >
              <Music2 className="h-5 w-5" />
            </Link>
          </div>
        </div>

        <hr className="border-white/20 w-full mb-4" />

        <div className="flex flex-col md:flex-row items-center justify-between w-full text-xs md:text-sm text-white/70 gap-3">
          <p>
            © {year} {t("brand")}. {t("rights")}
          </p>
          <p>
            {t("powered")} <span className="font-semibold">UnoCode</span>
          </p>
        </div>
      </div>
    </footer>
  );
}
